/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.SuffixArray;
import net.minecraft.util.ResourceLocation;

public class SearchTreeReloadable<T>
implements IMutableSearchTree<T> {
    protected SuffixArray<T> field_217875_a = new SuffixArray();
    protected SuffixArray<T> field_217876_b = new SuffixArray();
    private final Function<T, Stream<ResourceLocation>> field_217877_c;
    private final List<T> field_217878_d = Lists.newArrayList();
    private final Object2IntMap<T> field_217879_e = new Object2IntOpenHashMap();

    public SearchTreeReloadable(Function<T, Stream<ResourceLocation>> function) {
        this.field_217877_c = function;
    }

    @Override
    public void func_194040_a() {
        this.field_217875_a = new SuffixArray();
        this.field_217876_b = new SuffixArray();
        for (T t : this.field_217878_d) {
            this.func_194042_b(t);
        }
        this.field_217875_a.func_194058_a();
        this.field_217876_b.func_194058_a();
    }

    @Override
    public void func_217872_a(T t) {
        this.field_217879_e.put(t, this.field_217878_d.size());
        this.field_217878_d.add(t);
        this.func_194042_b(t);
    }

    @Override
    public void func_217871_a() {
        this.field_217878_d.clear();
        this.field_217879_e.clear();
    }

    protected void func_194042_b(T t) {
        this.field_217877_c.apply(t).forEach(resourceLocation -> {
            this.field_217875_a.func_194057_a(t, resourceLocation.func_110624_b().toLowerCase(Locale.ROOT));
            this.field_217876_b.func_194057_a(t, resourceLocation.func_110623_a().toLowerCase(Locale.ROOT));
        });
    }

    protected int func_217874_a(T t, T t2) {
        return Integer.compare(this.field_217879_e.getInt(t), this.field_217879_e.getInt(t2));
    }

    @Override
    public List<T> func_194038_a(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return this.field_217876_b.func_194055_a(string);
        }
        List<T> \u26032 = this.field_217875_a.func_194055_a(string.substring(0, n).trim());
        String \u26033 = string.substring(n + 1).trim();
        List<T> \u26034 = this.field_217876_b.func_194055_a(\u26033);
        return Lists.newArrayList(new JoinedIterator<T>(\u26032.iterator(), \u26034.iterator(), this::func_217874_a));
    }

    public static class JoinedIterator<T>
    extends AbstractIterator<T> {
        private final PeekingIterator<T> field_217881_a;
        private final PeekingIterator<T> field_217882_b;
        private final Comparator<T> field_217883_c;

        public JoinedIterator(Iterator<T> iterator, Iterator<T> iterator2, Comparator<T> comparator) {
            this.field_217881_a = Iterators.peekingIterator(iterator);
            this.field_217882_b = Iterators.peekingIterator(iterator2);
            this.field_217883_c = comparator;
        }

        protected T computeNext() {
            while (this.field_217881_a.hasNext() && this.field_217882_b.hasNext()) {
                int n = this.field_217883_c.compare(this.field_217881_a.peek(), this.field_217882_b.peek());
                if (n == 0) {
                    this.field_217882_b.next();
                    return (T)this.field_217881_a.next();
                }
                if (n < 0) {
                    this.field_217881_a.next();
                    continue;
                }
                this.field_217882_b.next();
            }
            return (T)this.endOfData();
        }
    }
}

